; ===============================================================================================================================
; Title .........: T2CoopServer.au3
; Author ........: BehemothProgrammer
; Version .......: 1.8
; ===============================================================================================================================

;Must run from exe for console functions to work

#include <Console.au3>

#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <TrayConstants.au3>
#include <MsgBoxConstants.au3>
#include <File.au3>
#include <StaticConstants.au3>
#include <Inet.au3>
#include <GuiToolTip.au3>
#include <GuiListBox.au3>
#include <GuiScrollBars.au3>
#include <GuiTab.au3>
#include <GuiComboBox.au3>
#include <WinAPIGdi.au3>
#include <Array.au3>

Opt("TrayOnEventMode",1)
Opt("TrayMenuMode",1)
Global $exitProgram = False
TraySetOnEvent($TRAY_EVENT_PRIMARYUP, "TrayPrimaryUp")
Global $trayItemExit = TrayCreateItem("Exit")
TrayItemSetOnEvent($trayItemExit, "TrayExit")
TraySetClick(8) ;right clicked

$__gvKernel32 = DllOpen("kernel32.dll")

Global Const $sVersion = "1.8"
Global Const $iMaxConsoleItems = 1000
Global Const $iMaxConsoleHistory = 10
Global Const $sConfigPath = @ScriptDir & "\t2ds_config.ini"
Global Const $sSaveGamePath = "saves\coop"
Global Const $sSaveGameExt = ".txt"
Global Const $sSaveGameCallCommand = "BP::SaveCoopProgress"
Global Const $sStartCommandChar = "!"
Global Const $sEndCommandChar = "@"
Global Const $iCommandCount = 2
Global Const $sMapDefault = "levels/mp/NewGame.map"
Global Const $sMapList = "levels/mp/HUB.map|levels/mp/Port_of_Adia_1.map|levels/mp/Port_of_Adia_2.map|levels/mp/Port_of_Adia_3.map|levels/mp/Port_of_Adia_4.map|levels/mp/Port_of_Adia_5.map|levels/mp/Port_of_Adia_6.map|levels/mp/Port_of_Adia_7.map|levels/mp/Port_Totem.map|levels/mp/RiverOfSouls_1.map|levels/mp/RiverOfSouls_2.map|levels/mp/RiverOfSouls_3.map|levels/mp/RiverOfSouls_4.map|levels/mp/RiverOfSouls_5.map|levels/mp/RiverOfSouls_6.map|levels/mp/RiverOfSouls_7.map|levels/mp/RiverOfSouls_8.map|levels/mp/River_Totem.map|levels/mp/Death_Marsh_1.map|levels/mp/Death_Marsh_2.map|levels/mp/Death_Marsh_3.map|levels/mp/Death_Marsh_4.map|levels/mp/Death_Marsh_5.map|levels/mp/Death_Marsh_6.map|levels/mp/Death_Marsh_7.map|levels/mp/Death_Marsh_Totem.map|levels/mp/Blind_Lair_1.map|levels/mp/Blind_Lair_2.map|levels/mp/Blind_Lair_3.map|levels/mp/Blind_Lair_4.map|levels/mp/Blind_Lair_5.map|levels/mp/Blind_Lair_6.map|levels/mp/Blind_Lair_7.map|levels/mp/Blind_Lair_8.map|levels/mp/Blind_Totem.map|levels/mp/Blind_One_Boss.map|levels/mp/Hive_1.map|levels/mp/Hive_2.map|levels/mp/Hive_3.map|levels/mp/Hive_4.map|levels/mp/Hive_5.map|levels/mp/Hive_6.map|levels/mp/Hive_7.map|levels/mp/Hive_8.map|levels/mp/Hive_9.map|levels/mp/Hive_10.map|levels/mp/Hive_11.map|levels/mp/Hive_Totem.map|levels/mp/Hive_Boss.map|levels/mp/Lightship_1.map|levels/mp/Lightship_2.map|levels/mp/Lightship_3.map|levels/mp/Lightship_4.map|levels/mp/Lightship_5.map|levels/mp/Lightship_6.map|levels/mp/Lightship_7.map|levels/mp/Lightship_8.map|levels/mp/Lightship_9.map|levels/mp/Lightship_10.map|levels/mp/Mother_Boss.map|levels/mp/Primagen_Boss.map|levels/mp/doome1m1.map|levels/mp/T3_level1.map|levels/mp/fossil-cavern6464.map|levels/mp/b464.map|levels/mp/blood1.map|levels/mp/seppuku.map|levels/mp/extra_adia_port.map|levels/mp/extra_adia_tunnels.map|levels/mp/extra_dmswamp.map"
Global $aryCommands[$iCommandCount] = ["map", "save"]
Global $aryCommandAllowClient[$iCommandCount] = [True, False]

Global $hConsoleWriteFile = -1
Global $bAllowClientCommands = False
Global $iCommandProcessing = -1
Global $sCommandMap = ""
Global $iCommandSaveLength = 0
Global $iCommandSaveDif = 0
Global $bCommandSaveEnd = False
Global $aryCommandHistory[$iMaxConsoleHistory]
Global $iCommandHistoryIndex = -1
Global $arySaveData[1] = [0]
Global $sLastConsoleWritePath = ""
;Setup command strings
Global $aryCommandsEnd[$iCommandCount]
For $i = 0 to $iCommandCount - 1
   $aryCommandsEnd[$i] = $sEndCommandChar & $aryCommands[$i] & $sEndCommandChar
   $aryCommands[$i] = $sStartCommandChar & $aryCommands[$i] & $sStartCommandChar
Next

;Setup Command History Array
For $i = 0 to $iMaxConsoleHistory - 1
   $aryCommandHistory[$i] = ""
Next

Local $hGUI = GUICreate("Turok 2 Co-Op Dedicated Server v" & $sVersion, 480, 280, -1, -1, $WS_MINIMIZEBOX+$WS_CAPTION+$WS_POPUP+$WS_SYSMENU)

Global $dummyEnterControl = GUICtrlCreateDummy()
Global $dummyUpControl = GUICtrlCreateDummy()
Global $dummyDownControl = GUICtrlCreateDummy()
; Set an accelerator key - ENTER will fire $dummyEnterControl
Local $aAccelKeys[3][2] = [["{ENTER}", $dummyEnterControl], ["{UP}", $dummyUpControl], ["{DOWN}", $dummyDownControl]]
GUISetAccelerators($aAccelKeys, $hGUI)

;-----Server Not Running GUI
Global $lblExePath = GUICtrlCreateLabel("horus_x64_ded.exe", 4, 6, 100, 20)
Global $txtExePath = GUICtrlCreateInput("", 100, 4, 350, 20)
Global $btnExeBrowse = GUICtrlCreateButton("...", 452, 3, 25, 22)
GUICtrlSetTip($lblExePath, "The full path to horus_x64_ded.exe")

Global $grpServer = GUICtrlCreateGroup("Server", 4, 26, 472, 220)

Global $lblServerName = GUICtrlCreateLabel("Name", 8, 42, 70, 20)
Global $txtServerName = GUICtrlCreateInput("", 80, 40, 390, 20)
GUICtrlSetTip($lblServerName, "The server name as listed to master server clients")

Global $lblServerMap = GUICtrlCreateLabel("Start Map", 8, 64, 70, 20)
GUICtrlSetTip($lblServerMap, "The chosen map to start on. Default: levels/mp/NewGame.map")
Global $cmbServerMap = GUICtrlCreateCombo($sMapDefault, 80, 62, 390, 20, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL, $WS_VSCROLL))
GUICtrlSetData($cmbServerMap, $sMapList)

Global $lblServerWebsite = GUICtrlCreateLabel("Website", 8, 86, 70, 20)
Global $txtServerWebsite = GUICtrlCreateInput("", 80, 84, 390, 20)
GUICtrlSetTip($lblServerWebsite, "The website for the server details. Can be shown/used by 3rd party master server clients." & @CRLF & "(Best used to direct to a mod file.)")

Global $lblServerEmail = GUICtrlCreateLabel("Email", 8, 108, 70, 20)
Global $txtServerEmail = GUICtrlCreateInput("", 80, 106, 390, 20)
GUICtrlSetTip($lblServerEmail, "The email address for the server details. Can be shown/used by 3rd party master server clients.")

Global $lblServerMaxPlayers = GUICtrlCreateLabel("Max Players", 8, 130, 70, 20)
Global $txtServerMaxPlayers = GUICtrlCreateInput("", 80, 128, 60, 20, $ES_NUMBER)
GUICtrlSetTip($lblServerMaxPlayers, "The number of players that can join the game. Up to a maximum of 16 players.")

Global $lblServerPFMOverlap = GUICtrlCreateLabel("PFM Overlap", 8, 152, 70, 20)
Global $txtServerPFMOverlap = GUICtrlCreateInput("", 80, 150, 60, 20, $ES_NUMBER)
GUICtrlSetTip($lblServerPFMOverlap, "The over lapping threshold of PFM mines before they detonate automatically. Default: 4")

Global $lblServerPort = GUICtrlCreateLabel("Port", 8, 174, 70, 20)
Global $txtServerPort = GUICtrlCreateInput("", 80, 172, 60, 20, $ES_NUMBER)
GUICtrlSetTip($lblServerPort, "The port number used when hosting the game. If the port is already used," & @CRLF & _
							  "the server attempts to allocate the next available port. Default: 5029")

Global $lblServerCustomArgs = GUICtrlCreateLabel("Additional Args", 8, 198, 70, 20)
Global $txtServerCustomArgs = GUICtrlCreateInput("", 80, 196, 390, 20)
GUICtrlSetTip($lblServerCustomArgs, "You may give any additional launch parameters here")

Global $btnServerPublic = GUICtrlCreateRadio("Public", 180, 222, 80, 20)
Global $btnServerPrivate = GUICtrlCreateRadio("Private", 262, 222, 80, 20)
GUICtrlSetTip($btnServerPublic, "Server is broadcasted to the master server")
GUICtrlSetTip($btnServerPrivate, "Server is not broadcasted to the master server")

Global $btnServerRun = GUICtrlCreateButton("Start Server", 200, 249, 100, 25)

;---Server Running GUI
Global $tabServer = GUICtrlCreateTab(0, 2, 480, 278)

;Console Tab
Global $tabItemConsole = GUICtrlCreateTabItem("Console")

Global $lstConsole = _GUICtrlListBox_Create($hGUI, "", 2, 26, 472, 240, BitOR($LBS_HASSTRINGS, $LBS_NODATA, $LBS_NOSEL, $WS_HSCROLL, $WS_VSCROLL, $WS_BORDER))
_GUICtrlListBox_BeginUpdate($lstConsole)
_GUICtrlListBox_ResetContent($lstConsole)
_GUICtrlListBox_InitStorage($lstConsole, $iMaxConsoleItems, 256)
_GUICtrlListBox_SetHorizontalExtent($lstConsole, 2900)
_GUICtrlListBox_EndUpdate($lstConsole)

;Global $lblSendCommand = GUICtrlCreateLabel("Command", 8, 206, 100, 20)
Global $cmbSendCommandType = GUICtrlCreateCombo("Command", 4, 256, 70, 20, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL, $WS_VSCROLL))
Global $txtSendCommand = GUICtrlCreateInput("", 76, 256, 358, 20)
Global $btnSendCommand = GUICtrlCreateButton("Send", 435, 256, 40, 20)
GUICtrlSetData($cmbSendCommandType, "Map")
;GUICtrlSetTip($cmbSendCommandType, "Type Command or Change the Map")

Global $cmbSendMap = GUICtrlCreateCombo($sMapDefault, 76, 256, 358, 20, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL, $WS_VSCROLL))
GUICtrlSetData($cmbSendMap, $sMapList)

;Save/Load Tab
GUICtrlCreateTabItem("Save/Load")
Global $btnSaveGame0 = GUICtrlCreateButton("Save", 78, 36, 60, 22)
Global $btnLoadGame0 = GUICtrlCreateButton("Load", 140, 36, 60, 22)
Global $btnAutoLoadGame = GUICtrlCreateButton("Load Auto Save", 380, 36, 90, 22)
Global $lblSlot = GUICtrlCreateLabel("Slot", 8, 40, 30, 20)
Global $cmbSaveLoadSlot = GUICtrlCreateCombo("1", 32, 36, 40, 20, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL, $WS_VSCROLL))
GUICtrlSetData($cmbSaveLoadSlot, "2|3|4|5|6|7|8|9")

;Global $lblSaveInfo = GUICtrlCreateLabel("Advice: Try to save over multiple slots as you play through the game instead of the same one all the time (just in case)." & @CRLF & @CRLF & "Save files are stored in the games saves/ folder", 8, 60, 460, 80)
;Global $lblSaveInfo2 = GUICtrlCreateLabel("Advanced User:", 8, 190, 80, 20)
;Global $lblSaveInfo3 = GUICtrlCreateEdit("To Load manually: Type in the console: callfile ""saves\coop1.txt"" L" & @CRLF & "and change the number to any slot value from 1 to 9" & @CRLF & @CRLF & "To Save manually from the current slot: Type in the console: call BP::SaveCoopProgress" & @CRLF & "", 8, 210, 460, 60, BitOR($ES_MULTILINE, $ES_READONLY))

;Settings Tab
GUICtrlCreateTabItem("Settings")

Global $cbSaveConsole2 = GUICtrlCreateCheckbox("Console Output", 8, 28, 100, 20)
Global $txtSaveConsole2 = GUICtrlCreateInput("", 110, 26, 310, 20)
Global $btnSaveConsole2 = GUICtrlCreateButton("...", 425, 26, 22, 22)
GUICtrlSetTip($cbSaveConsole2, "Enable to specify where to save the console text." & @CRLF & "Disable to not save to a file.")

Global $cbAllowClientCommands = GUICtrlCreateCheckbox("Allow Client Commands", 8, 50, 200, 20)
GUICtrlSetTip($cbAllowClientCommands, "Allows clients to change the map with the say command")

Global $cbEnableMapChange = GUICtrlCreateCheckbox("Enable Auto Map Change", 8, 72, 200, 20)
GUICtrlSetTip($cbEnableMapChange, "Enables the map to change automatically")

Global $btnShowConsoleWindow = GUICtrlCreateButton("Show Console", 8, 250, 80, 22)
Global $btnHideConsoleWindow = GUICtrlCreateButton("Hide Console", 90, 250, 80, 22)

Global $cbEnableDevMode = GUICtrlCreateCheckbox("Debug Mode", 380, 250, 80, 20)
GUICtrlSetTip($cbEnableDevMode, "Console output saves read lines as is. (Use for debugging only as this has a performance hit)")

;Info Tab
GUICtrlCreateTabItem("Info")
Global $lblPublicIP = GUICtrlCreateLabel("Public IP", 8, 28, 80, 20)
Global $txtPublicIP = GUICtrlCreateInput("", 80, 26, 310, 20, $ES_READONLY)
Global $btnPublicIPRefresh = GUICtrlCreateButton("Refresh", 395, 26, 45, 22)
GUICtrlSetTip($lblPublicIP, "Public IP address of this computer or network." & @CRLF & "(i.e. the public IP on the WAN link of your NAT router)")
GUICtrlSetTip($btnPublicIPRefresh, "To reduce overloading the IP discovery sites a 5 minute timer is used between each refresh." & @CRLF & _
									"The address is determined by accessing an external IP discovery web site." & @CRLF & _
									"The sites used are https://www.ipify.org, http://checkip.dyndns.org," & @CRLF & _
									"http://www.myexternalip.com/raw and http://www.bot.whatismyipaddress.com.")

Global $lblLocalIP = GUICtrlCreateLabel("Local IP", 8, 54, 80, 20)
Global $txtLocalIP = GUICtrlCreateInput(@IPAddress1, 80, 50, 310, 20, $ES_READONLY)
GUICtrlSetTip($lblLocalIP, "IP address of first network adapter")

Global $lblPortInfo = GUICtrlCreateLabel("Port", 8, 76, 80, 20)
Global $txtPortInfo = GUICtrlCreateInput("", 80, 74, 80, 20, $ES_READONLY)

Global $lblCredits = GUICtrlCreateLabel("v" & $sVersion & " by BehemothProgrammer", 310, 260, 160, 20, $SS_RIGHT)

GUICtrlCreateTabItem("") ; end tabitem definition

GUISetState(@SW_SHOW, $hGUI)

;//Load ini file
Local $sExePath = IniRead($sConfigPath, "General", "ExePath", "")
Local $iAllowClientCommands = IniRead($sConfigPath, "General", "AllowClientCommands", $GUI_UNCHECKED)
Local $iEnableMapChange = IniRead($sConfigPath, "General", "EnableMapChange", $GUI_CHECKED)
Local $iEnableDevMode = IniRead($sConfigPath, "General", "EnableDebugMode", $GUI_UNCHECKED)
Local $iEnableConsoleOutput = IniRead($sConfigPath, "General", "EnableConsoleOutput", $GUI_UNCHECKED)
Local $sConsoleOutput = IniRead($sConfigPath, "General", "ConsoleOutput", "")
For $i = 0 to $iMaxConsoleHistory - 1
   $aryCommandHistory[$i] = IniRead($sConfigPath, "General", "CommandHistory" & $i, "")
Next
Local $sServerName = IniRead($sConfigPath, "Server", "Name", "We Are Turok")
Local $sServerMap = IniRead($sConfigPath, "Server", "Map", "levels/mp/NewGame.map")
Local $sServerWebsite = IniRead($sConfigPath, "Server", "Website", "")
Local $sServerEmail = IniRead($sConfigPath, "Server", "Email", "")
Local $iServerMaxPlayers = IniRead($sConfigPath, "Server", "MaxPlayers", 16)
Local $iServerPFMOverlap = IniRead($sConfigPath, "Server", "PFMOverlap", 4)
Local $iServerPort = IniRead($sConfigPath, "Server", "Port", 5029)
Local $iServerBroadcast = IniRead($sConfigPath, "Server", "Broadcast", $GUI_CHECKED)
Local $sServerCustomArgs = IniRead($sConfigPath, "Server", "CustomArgs", "")
GUICtrlSetData($txtExePath, $sExePath)
GUICtrlSetData($txtServerName, $sServerName)
Local $iCmbMapIndex = _GUICtrlComboBox_FindStringExact($cmbServerMap, $sServerMap)
If $iCmbMapIndex <> -1 Then
   _GUICtrlComboBox_SetCurSel($cmbServerMap, $iCmbMapIndex)
EndIf
_GUICtrlComboBox_SetEditText($cmbServerMap, $sServerMap)
GUICtrlSetData($txtServerWebsite, $sServerWebsite)
GUICtrlSetData($txtServerEmail, $sServerEmail)
GUICtrlSetData($txtServerMaxPlayers, $iServerMaxPlayers)
GUICtrlSetData($txtServerPFMOverlap, $iServerPFMOverlap)
GUICtrlSetData($txtServerPort, $iServerPort)
GUICtrlSetData($txtServerCustomArgs, $sServerCustomArgs)
GUICtrlSetState($cbAllowClientCommands, $iAllowClientCommands)
GUICtrlSetState($cbEnableMapChange, $iEnableMapChange)
GUICtrlSetState($cbEnableDevMode, $iEnableDevMode)
GUICtrlSetState($cbSaveConsole2, $iEnableConsoleOutput)
If $iServerBroadcast == $GUI_CHECKED Then
   GUICtrlSetState($btnServerPublic, $GUI_CHECKED)
Else
   GUICtrlSetState($btnServerPrivate, $GUI_CHECKED)
EndIf

CheckConsoleOutputEnabled()
SetConsolePath($sConsoleOutput)

Global $consolePID = 0
Global $hConsoleWindow = 0
Global $hConsoleOutput = 0
Global $lastProcessExists = False
Global $consoleReadTimer = TimerInit() ; Begin the timer and store the handle in a variable.
Global $consoleTimerOn = False
Global $manualSaveTimer = TimerInit()
Global $lastPosY = 0 ; //last console Y Pos
Global $lastTabIndex = 0
Global $consoleBufferError = False
Global $consoleReadOnce = False

;ShowGUIServerRunning()
ShowGUIStart()

;Local $consoleScreenBufferInfo = 0
While True
   CheckConsoleProcess()

   If $lastProcessExists Then
	  TryConsoleRead()
   EndIf

   If $exitProgram Then
	  ExitLoop
   EndIf

   UpdateTabIndex()

   Switch GUIGetMsg()
	  Case $GUI_EVENT_CLOSE
		 TryExit()
	  Case $GUI_EVENT_MINIMIZE
		 GuiSetState(@SW_HIDE)
		 TraySetToolTip("Turok 2 Co-Op Server")
	  Case $dummyEnterControl ;Pressed Enter
		 If SendInputHasFocus() Then
			SendInputToConsole()
		 EndIf
	  Case $dummyUpControl ;Pressed Up Arrow
		 If SendInputHasFocus() Then
			For $i = 0 to $iMaxConsoleHistory - 1
			   $iCommandHistoryIndex += 1
			   If ($iCommandHistoryIndex >= $iMaxConsoleHistory) Then
				  $iCommandHistoryIndex = 0
			   EndIf
			   If ($aryCommandHistory[$iCommandHistoryIndex] <> "") Then
				  GUICtrlSetData($txtSendCommand, $aryCommandHistory[$iCommandHistoryIndex])
				  ExitLoop
			   EndIf
			Next
		 EndIf
	  Case $dummyDownControl ;Pressed Down Arrow
		 If SendInputHasFocus() Then
			For $i = 0 to $iMaxConsoleHistory - 1
			   $iCommandHistoryIndex -= 1
			   If ($iCommandHistoryIndex < 0) Then
				  $iCommandHistoryIndex = $iMaxConsoleHistory - 1
			   EndIf
			   If ($aryCommandHistory[$iCommandHistoryIndex] <> "") Then
				  GUICtrlSetData($txtSendCommand, $aryCommandHistory[$iCommandHistoryIndex])
				  ExitLoop
			   EndIf
			Next
		 EndIf
	  Case $btnServerRun
		 If $consolePID = 0 Then
			Local $sServerEmail = GUICtrlRead($txtServerEmail)
			Local $sServerWebsite = GUICtrlRead($txtServerWebsite)
			Local $sServerMap = GUICtrlRead($cmbServerMap)
			Local $sServerName = GUICtrlRead($txtServerName)
			;Games knows it's a dedicated server if the name is not "Turok2 Server" so make sure that can never be set
			if $sServerName == "Turok2 Server" Then
			   $sServerName = "Coop"
			EndIf
			Local $iServerMaxPlayers = GUICtrlRead($txtServerMaxPlayers)
			Local $iServerPFMOverlap = GUICtrlRead($txtServerPFMOverlap)
			Local $iServerPort = GUICtrlRead($txtServerPort)
			Local $iServerBroadCast = (_IsChecked($btnServerPublic) ? "1" : "0")
			Local $sServerCArgs = StringStripWS(GUICtrlRead($txtServerCustomArgs), $STR_STRIPLEADING + $STR_STRIPTRAILING + $STR_STRIPSPACES)
			Local $sServerArgs = " -port " & $iServerPort & " +sv_gamemode 7 +sv_email """ & $sServerEmail & """ +sv_map """ & $sServerMap & """ +sv_website """ & $sServerWebsite & """ +sv_directservername """ & $sServerName & _
								 """ +sv_maxplayers " & $iServerMaxPlayers & " +sv_broadcast " & $iServerBroadCast & " +sv_fraglimit 0 +sv_timelimit 0 +sv_pointlimit 0 +sv_forcebalanceteams 0 +sv_pfm_maxoverlap " & $iServerPFMOverlap & _
								 " +sv_rf_hydra 0 +sv_rf_minperplayer 1 +sv_rf_maxenemies 100"
			If $sServerCArgs <> "" Then
			   $sServerArgs &= " " & $sServerCArgs
			EndIf

			Local $sExePath = GUICtrlRead($txtExePath)
			$consolePID = Run($sExePath & $sServerArgs, "", @SW_SHOW)
			ProcessWait($consolePID)
			_Console_Attach($consolePID, $__gvKernel32)
			$hConsoleWindow = _Console_GetWindow($__gvKernel32) ;Get Console Window Handle
			$hConsoleOutput = _Console_GetStdHandle($STD_OUTPUT_HANDLE, $__gvKernel32)
			WinSetState($hConsoleWindow, "", @SW_HIDE)
			_Console_SetScreenBufferSize($hConsoleOutput, 256, 300, $__gvKernel32)
			;_WinAPI_SetWindowLong($hConsoleWindow, $GWL_STYLE, BitXOR(_WinAPI_GetWindowLong($hConsoleWindow, $GWL_STYLE), $WS_SIZEBOX)) ;Disable the Ability to resize the console window
			CheckConsoleProcess()
		 EndIf
	  Case $btnExeBrowse
		 Local $sFileOpenDialog = FileOpenDialog("Select horus_x64_ded.exe", "", "(horus_x64_ded.exe)|Executable (*.exe)", $FD_FILEMUSTEXIST)
		 If Not @error Then
			GUICtrlSetData($txtExePath, $sFileOpenDialog)
			IniWrite($sConfigPath, "General", "ExePath", $sFileOpenDialog)
		 EndIf
	  Case $txtServerName
		 IniWrite($sConfigPath, "Server", "Name", GUICtrlRead($txtServerName))
	  Case $cmbServerMap
		 IniWrite($sConfigPath, "Server", "Map", GUICtrlRead($cmbServerMap))
	  Case $txtServerWebsite
		 IniWrite($sConfigPath, "Server", "Website", GUICtrlRead($txtServerWebsite))
	  Case $txtServerEmail
		 IniWrite($sConfigPath, "Server", "Email", GUICtrlRead($txtServerEmail))
	  Case $txtServerMaxPlayers
		 IniWrite($sConfigPath, "Server", "MaxPlayers", GUICtrlRead($txtServerMaxPlayers))
	  Case $txtServerPFMOverlap
		 IniWrite($sConfigPath, "Server", "PFMOverlap", GUICtrlRead($txtServerPFMOverlap))
	  Case $txtServerPort
		 IniWrite($sConfigPath, "Server", "Port", GUICtrlRead($txtServerPort))
	  Case $cbAllowClientCommands
		 IniWrite($sConfigPath, "General", "AllowClientCommands", GUICtrlRead($cbAllowClientCommands))
	  Case $cbEnableDevMode
		 If _IsChecked($cbEnableDevMode) Then
		 	Local $msgID = MsgBox($MB_YESNO, "Enable Debug Mode?", "Are you sure you want to enable Debug Mode? It can have a performance impact and should only be used to help BehemothProgrammer fix any problems you might be having with this program.")
			If $msgID = $IDNO Then
			   GUICtrlSetState($cbEnableDevMode, $GUI_UNCHECKED)
			EndIf
		 EndIf
		 IniWrite($sConfigPath, "General", "EnableDebugMode", GUICtrlRead($cbEnableDevMode))
	  Case $cbEnableMapChange
		 If Not _IsChecked($cbEnableMapChange) Then
		 	Local $msgID = MsgBox($MB_YESNO, "Disable Auto Map Change?", "Are you sure you want to disable Auto Map Change? (It's pretty much the main feature of this program)")
			If $msgID = $IDNO Then
			   GUICtrlSetState($cbEnableMapChange, $GUI_CHECKED)
			EndIf
		 EndIf
		 IniWrite($sConfigPath, "General", "EnableMapChange", GUICtrlRead($cbEnableMapChange))
	  Case $btnSendCommand
		 Local $iIndex = _GUICtrlComboBox_GetCurSel($cmbSendCommandType)
		 Switch $iIndex
			Case 0 ;Command
			   SendInputToConsole()
			Case 1 ;Map
			   ChangeMap(GUICtrlRead($cmbSendMap))
		 EndSwitch
	  Case $btnPublicIPRefresh
		 Local $sPublicIP = _GetIP()
		 If $sPublicIP == -1 Then
			MsgBox($MB_SYSTEMMODAL, "Error", "Unable to Obtain Public IP")
		 Else
			GUICtrlSetData($txtPublicIP, $sPublicIP)
		 EndIf
	  Case $btnSaveConsole2
		 Local $sFileSaveDialog = FileSaveDialog("Save Console to Text File", "", "Text File (*.txt)", $FD_PROMPTOVERWRITE, "CoopConsole.txt")
		 If Not @error Then
			SetConsolePath($sFileSaveDialog)
		 EndIf
	  Case $cbSaveConsole2
		 Local $acceptChange = True
		 If $hConsoleWriteFile <> -1 Then
			If _IsChecked($cbSaveConsole2)Then
			   ;nothing
			Else
			   GUICtrlSetState($cbSaveConsole2, $GUI_CHECKED)
			   Local $msgID = MsgBox($MB_YESNO, "Close Console Output File", "Are you sure you want to stop writing to the console output file?")
			   If $msgID = $IDYES Then
				  FileClose($hConsoleWriteFile)
				  $hConsoleWriteFile = -1
				  GUICtrlSetState($cbSaveConsole2, $GUI_UNCHECKED)
			   Else
				  $acceptChange = False
			   EndIf
			EndIf
		 EndIf
		 If $acceptChange Then
			IniWrite($sConfigPath, "General", "EnableConsoleOutput", GUICtrlRead($cbSaveConsole2))
			CheckConsoleOutputEnabled()
		 EndIf
	  Case $txtSaveConsole2
		 SetConsolePath(GUICtrlRead($txtSaveConsole2))
	  Case $btnServerPublic, $btnServerPrivate
		 IniWrite($sConfigPath, "Server", "Broadcast", GUICtrlRead($btnServerPublic))
	  Case $txtServerCustomArgs
		 IniWrite($sConfigPath, "Server", "CustomArgs", GUICtrlRead($txtServerCustomArgs))
	  Case $btnSaveGame0
		 $manualSaveTimer = TimerInit()
		 SendCommandToConsole("call " & $sSaveGameCallCommand)
		 _GUICtrlTab_ClickTab($tabServer, 0)
		 ConsoleListScrollToBottom()
	  Case $btnLoadGame0
		 Local $sSlot = GUICtrlRead($cmbSaveLoadSlot)
		 SendCommandToConsole("callfile """ & $sSaveGamePath & $sSlot & $sSaveGameExt & """ L")
		 _GUICtrlTab_ClickTab($tabServer, 0)
		 ConsoleListScrollToBottom()
	  Case $btnAutoLoadGame
		 Local $sSlot = "Auto"
		 SendCommandToConsole("callfile """ & $sSaveGamePath & $sSlot & $sSaveGameExt & """ L")
		 _GUICtrlTab_ClickTab($tabServer, 0)
		 ConsoleListScrollToBottom()
	  Case $cmbSendCommandType
		 UpdateCommandType()
	  Case $btnShowConsoleWindow
		 WinSetState($hConsoleWindow, "", @SW_SHOW)
	  Case $btnHideConsoleWindow
		 WinSetState($hConsoleWindow, "", @SW_HIDE)
   EndSwitch
WEnd

GUIDelete($hGUI)
_Console_Free()
ProcessClose($consolePID)
Exit
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func SendCommandToConsole($command)
   ;ControlSend($hConsoleWindow, "", "", "{Enter}")
   Return ControlSend($hConsoleWindow, "", "", $command & "{Enter}")
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func SendInputToConsole()
   Local $sCommand = GUICtrlRead($txtSendCommand)
   if $sCommand <> "" Then
	  SendCommandToConsole($sCommand)
	  GUICtrlSetData($txtSendCommand, "")
	  $iCommandHistoryIndex = -1
	  _ArrayPush($aryCommandHistory, $sCommand, 1)
	  For $i = 0 to $iMaxConsoleHistory - 1
		 IniWrite($sConfigPath, "General", "CommandHistory" & $i, $aryCommandHistory[$i])
	  Next
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func SendInputHasFocus()
   Return (_WinAPI_GetFocus() = GUICtrlGetHandle($txtSendCommand) And $lastProcessExists And _GUICtrlTab_GetCurSel($tabServer) = 0)
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func TryExit()
   If $lastProcessExists Then
	  Local $msgID = MsgBox($MB_YESNO, "Confirm Exit", "Server is running. Are you sure you want to exit and shutdown the server?")
	  If $msgID = $IDNO Then
		 Return
	  EndIf
   EndIf
   $exitProgram = True
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func TryConsoleRead()
   Local $consoleScreenBufferInfo = _Console_GetScreenBufferInfo($hConsoleOutput, $__gvKernel32)
   If $consoleScreenBufferInfo <> 0 Then
	  $consoleReadOnce = True
	  Local $posy = $consoleScreenBufferInfo.CursorPositionY
	  ;Theres new text to process
	  If $posy > 0 Then
		 ;wait at least .2 seconds after messages have stopped showing
		 If $lastPosY <> $posy Then
			$lastPosY = $posy
			$consoleReadTimer = TimerInit()
		 EndIf
		 If TimerDiff($consoleReadTimer) > 200 Then
			$lastPosY = 0
			$iCommandProcessing = -1
			Local $bScrollToEnd = IsConsoleScrollAtBottom()
			Local $iMaxWindowSizeX = $consoleScreenBufferInfo.MaximumWindowSizeX
			Local $bOutputToFile = _IsChecked($cbSaveConsole2)
			$bAllowClientCommands = _IsChecked($cbAllowClientCommands)
			$sCommandMap = ""
			$iCommandSaveLength = 0
			$bCommandSaveEnd = False
			$arySaveData[0] = 0
			ReDim $arySaveData[$arySaveData[0] + 1]
			For $i = 0 To $posy - 1 Step 1
			   Local $line = _Console_ReadOutputCharacter($hConsoleOutput, $iMaxWindowSizeX, 0, $i, True, $__gvKernel32)
			   Local $iConsoleListItemCount = _GUICtrlListBox_GetCount($lstConsole)
			   If $iConsoleListItemCount >= $iMaxConsoleItems Then
				  _GUICtrlListBox_ResetContent($lstConsole)
			   EndIf
			   ClearConsoleLine($iMaxWindowSizeX, $i)
			   Local $iPreCommandProcessing = $iCommandProcessing
			   ProcessConsoleLine($line) ;Process special commands
			   If $iCommandProcessing <> 1 And $iPreCommandProcessing <> 1 Then ;not a Save command then display in console
				  _GUICtrlListBox_AddString($lstConsole, $line)
			   EndIf
			   If $bOutputToFile Then
				  If _IsChecked($cbEnableDevMode) Then
					 WriteLineToConsoleFile($line)
				  Else
					 If $iCommandProcessing <> 1 And $iPreCommandProcessing <> 1 Then ;not a Save command then don't write to file
						Local $consoleOutputLine = StringStripWS($line, $STR_STRIPLEADING + $STR_STRIPTRAILING)
						If $consoleOutputLine <> "" Then
						   WriteLineToConsoleFile($consoleOutputLine)
						EndIf
					 EndIf
				  EndIf
			   EndIf
			Next

			;Clear the line the cursor is on as well
			ClearConsoleLine($iMaxWindowSizeX, $posy)

			;Process Last Map Command
			If $sCommandMap <> "" Then
			   ChangeMap($sCommandMap)
			EndIf

			;Process Last Save Command
			If $iCommandSaveLength <> 0 Then
			   If $bCommandSaveEnd Then
				  WriteSaveDataToFile()
			   Else
				  ShowSaveError("Found command to Save but no end was found")
			   EndIf
			EndIf

			If $bScrollToEnd Then
			   ConsoleListScrollToBottom()
			EndIf
			_Console_SetCursorPosition($hConsoleOutput, 0, 0, $__gvKernel32)
		 EndIf
	  EndIf
   Else
	  If Not $consoleReadOnce And Not $consoleBufferError Then
		 $consoleBufferError = True
		 MsgBox($MB_SYSTEMMODAL, "Error", "Unable to read from the console. Restart program and try again.")
		 _GUICtrlListBox_AddString($lstConsole, "Error - Unable to read from the console. Restart program and try again.")
	  EndIf
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ClearConsoleLine($sizeX, $row)
   For $j = 0 To 2 Step 1
	  If _Console_FillOutputCharacter($hConsoleOutput, " ", $sizeX, 0, $row, True, $__gvKernel32) = True Then
		 ExitLoop
	  EndIf
   Next
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ProcessConsoleLine($line)
   ;check what command currently checking for - None(which checks for all commands), Map, CoopSave
   Switch $iCommandProcessing
	  Case -1 ;None (checks for all commands)
		 ProcessNoneCommand($line)
	  Case 0 ;map
	  Case 1 ;save
		 ProcessSaveCommand($line)
   EndSwitch
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ProcessNoneCommand($line)
   Local $iLineStart = StringInStr($line, "]", 0, 1, 21, 1)
   If $iLineStart = 21 Then ;Position end of timestamp on print messages
	  $iLineStart += 2 ;go to first character for the message skipping the ] and the space characters
	  Local $lineLength = StringLen($line)

	  ;Loop through all available commands here
	  For $i = 0 to $iCommandCount - 1
		 Local $sCommand = $aryCommands[$i]
		 Local $iCommandLength = StringLen($sCommand)
		 Local $iLineMapCmdStart = StringInStr($line, $sCommand, $STR_NOCASESENSEBASIC, 1, $iLineStart)
		 Local $bIsValidCommand = False

		 ;Check if command is valid
		 If $bAllowClientCommands And $aryCommandAllowClient[$i] Then
			If $iLineMapCmdStart <> 0 Then
			   $bIsValidCommand = True
			Endif
		 Else
			If $iLineMapCmdStart = $iLineStart Then ;it's a server command
			   $bIsValidCommand = True
			;ElseIf $iLineMapCmdStart <> 0 Then ;client
			Endif
		 Endif

		 If $bIsValidCommand Then
			Local $sCommandArgs = StringRight($line, $lineLength - ($iLineMapCmdStart + ($iCommandLength - 1)))
			$sCommandArgs = StringStripWS($sCommandArgs, $STR_STRIPLEADING + $STR_STRIPTRAILING)
			Switch $i
			Case 0 ;Map
				  If _IsChecked($cbEnableMapChange) Then
					 $sCommandMap = $sCommandArgs
				  EndIf
			   Case 1 ;Save
				  If Not $bCommandSaveEnd Then
					 ;read the data length and the difficulty then every line after that is
					 Local $aryArgs = StringSplit($sCommandArgs, " ")
					 ;Expect 2 numbers (DataLength and Difficulty)
					 If $aryArgs[0] == 2 Then
						$iCommandSaveLength = Int($aryArgs[1])
						If $iCommandSaveLength > 0 Then
						   $iCommandSaveDif = Int($aryArgs[2])
						   ;If save dif is out of bounds 0..4 then set to 2(Hard)
						   If $iCommandSaveDif < 0 Or $iCommandSaveDif > 4 Then
							  $iCommandSaveDif = 2
						   EndIf
						   $iCommandProcessing = $i
						Else
						   ShowSaveError("Found command to Save and expected DataLength to be >= 0 but is " & $iCommandSaveLength)
						EndIf
					 Else
						ShowSaveError("Found command to Save and excepted 2 args but there was " & $aryArgs[0] & " args")
					 EndIf
				  EndIf
			EndSwitch
		 EndIf
	  Next
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ProcessSaveCommand($line)
   ;check at pos 21 for ] to know if the first 23 characters are used for the date then skip those
   Local $iLineStart = StringInStr($line, "]", 0, 1, 21, 1)
   Local $lineArgs
   If $iLineStart = 21 Then ;Position end of timestamp on print messages
	  $iLineStart += 2 ;go to first character for the message skipping the ] and the space characters
	  ;check for @save@ end
	  Local $sCommand = $aryCommandsEnd[1]
	  Local $iCommandLength = StringLen($sCommand)
	  Local $iLineMapCmdStart = StringInStr($line, $sCommand, $STR_NOCASESENSEBASIC, 1, $iLineStart, $iCommandLength)
	  If $iLineMapCmdStart <> 0 Then ;Found save end
		 $bCommandSaveEnd = True
		 $iCommandProcessing = -1
		 Return
	  EndIf

	  Local $lineLength = StringLen($line)
	  $lineArgs = StringRight($line, $lineLength - ($iLineStart - 1))
   Else
	  $lineArgs = $line
   EndIf
   ;continue getting data from entire line
   $lineArgs = StringStripWS($lineArgs, $STR_STRIPLEADING + $STR_STRIPTRAILING)
   If $lineArgs <> "" Then
	  Local $aryArgs = StringSplit($lineArgs, " ")
	  If $aryArgs[0] > 0 Then
		 Local $iSaveDataStartIndex = $arySaveData[0]
		 $arySaveData[0] += $aryArgs[0]
		 ReDim $arySaveData[$arySaveData[0] + 1]
		 For $i = 1 To $aryArgs[0] Step 1
			Local $bIsInt = StringIsInt($aryArgs[$i])
			Local $bIsFloat = StringIsFloat($aryArgs[$i])
			If Not $bIsInt And Not $bIsFloat Then
			   ShowSaveError("Save Arg was not an int or a float, " & $aryArgs[$i])
			   $iCommandProcessing = -1
			   $iCommandSaveLength = 0
			Else
			  $arySaveData[$iSaveDataStartIndex + $i] = Int($aryArgs[$i])
			EndIf
		 Next
	  EndIf
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func IsConsoleScrollAtBottom()
   ;Get if scrollbar is scrolled to the very bottom
   Local $tSCROLLINFO = _GUIScrollBars_GetScrollInfoEx($lstConsole, $SB_VERT)
   Local $iPageSize = DllStructGetData($tSCROLLINFO, "nPage")
   Local $iMaxItems = DllStructGetData($tSCROLLINFO, "nMax")
   Local $iPos = DllStructGetData($tSCROLLINFO, "nPos")
   Return ($iPos == ($iMaxItems - ($iPageSize - 1)))
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func UpdateTabIndex()
   Local $index = _GUICtrlTab_GetCurSel($tabServer)
   If $lastTabIndex <> $index Then
	  If $index = 0 Then ;Is Console
		 WinSetState($lstConsole, "", @SW_SHOW)
	  Else
		 WinSetState($lstConsole, "", @SW_HIDE)
	  EndIf
	  If $index = 0 Or $lastTabIndex = 0 Then
		 _WinAPI_RedrawWindow($hGUI)
	  EndIf
	  $lastTabIndex = $index
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ConsoleListScrollToBottom()
   Local $iItemCount = _GUICtrlListBox_GetCount($lstConsole) - 1
   _GUICtrlListBox_SetCurSel($lstConsole, $iItemCount)
   _GUICtrlListBox_SetCaretIndex($lstConsole, $iItemCount)
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func CheckConsoleOutputEnabled()
   If _IsChecked($cbSaveConsole2) Then
	  GUICtrlSetState($txtSaveConsole2, $GUI_ENABLE)
	  GUICtrlSetState($btnSaveConsole2, $GUI_ENABLE)
   Else
	  GUICtrlSetState($txtSaveConsole2, $GUI_DISABLE)
	  GUICtrlSetState($btnSaveConsole2, $GUI_DISABLE)
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func SetConsolePath($path)
   GUICtrlSetData($txtSaveConsole2, $path)
   IniWrite($sConfigPath, "General", "ConsoleOutput", $path)
   If _IsChecked($cbSaveConsole2) Then
	  If $sLastConsoleWritePath <> $path Then
		 $sLastConsoleWritePath = $path
		 If $hConsoleWriteFile <> -1 Then
			FileClose($hConsoleWriteFile)
			$hConsoleWriteFile = -1
		 EndIf
		 $hConsoleWriteFile = FileOpen($path, BitOR($FO_OVERWRITE, $FO_UTF8_NOBOM))
	  EndIf
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func WriteLineToConsoleFile($text)
   If $hConsoleWriteFile <> -1 Then
	  FileWriteLine($hConsoleWriteFile, $text)
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func WriteSaveDataToFile()
   If $arySaveData[0] > 0 And $iCommandSaveLength = $arySaveData[0] Then
	  Local $sExePath = GUICtrlRead($txtExePath)
	  Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
	  Local $aPathSplit = _PathSplit($sExePath, $sDrive, $sDir, $sFileName, $sExtension)
	  Local $sSlot = (IsManualSave() ? GUICtrlRead($cmbSaveLoadSlot) : "Auto")
	  ;Local $sSlot = GUICtrlRead($cmbSaveLoadSlot)
	  Local $sFilePath = $sDrive & $sDir & $sSaveGamePath & $sSlot & $sSaveGameExt
	  Local $writeFile = FileOpen($sFilePath, BitOR($FO_OVERWRITE, $FO_UTF8_NOBOM))
	  If $writeFile <> -1 Then
		 ;Make sure $arySaveData is multiple of 2
		 Local $iSizeRemainder = Mod($arySaveData[0], 2)
		 If $iSizeRemainder <> 0 Then
			Local $lastIndex = $arySaveData[0]
			$arySaveData[0] += (2 - $iSizeRemainder)
			ReDim $arySaveData[$arySaveData[0] + 1]
			For $i = ($lastIndex + 1) To $arySaveData[0] Step 1
			   $arySaveData[$i] = 0
			Next
		 EndIf

		 FileWrite($writeFile, "kActor@ F(){kActorIterator iter;kActor@ actor;while ((@actor = iter.GetNext()) !is null){if (actor.Type() >= 24000 && actor.Type() <= 24999){return @actor;}}return null;}void L(){if (!Network.IsNetgame() || !Network.IsServer()){Sys.Warning(""Save Error: Not a NetGame And Server"");return;} kActor@ actor = F(); if (actor is null){Sys.Warning(""Save Error: No map actor found"");return;}")
		 FileWrite($writeFile, "actor.TriggerMessageID() = " & $iCommandSaveLength & ";actor.TriggerData() =" & $iCommandSaveDif & ";array<int> d = {" & $arySaveData[1])
		 For $i = 2 To $arySaveData[0] Step 1
			FileWrite($writeFile, "," & $arySaveData[$i])
		 Next
		 FileWriteLine($writeFile, "};if (d.length() % 2 != 0){Sys.Warning(""Save Error: Incorrect Data Size"");return;}Event.RunAction(actor, null, 22, Math::vecZero, 102);for (uint i = 0; i < d.length(); i+=2){actor.TriggerMessageID() = d[i];actor.TriggerData() = d[i+1];Event.RunAction(actor, null, 22, Math::vecZero, 103);}Event.RunAction(actor, null, 22, Math::vecZero, 104);}")
		 FileClose($writeFile)
	  Else
		 ShowSaveError("Unable to open file for writing " & $sFilePath)
	  EndIf
   Else
	  ShowSaveError("Invalid Save Data Length. $iCommandSaveLength: " & $iCommandSaveLength & " $arySaveData[0]: " & $arySaveData[0])
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ShowSaveError($msg)
   ;only show msgbox if manually save
   If IsManualSave() Then
	  MsgBox($MB_SYSTEMMODAL, "Error", $msg)
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func IsManualSave()
   ;manually if pressed save within 2 seconds, not an autosave(not done through gui)
   Return TimerDiff($manualSaveTimer) < 2000
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ChangeMap($mapPath)
   Local $sendIsSuccess = SendCommandToConsole("netmap """ & $mapPath & """")
   If $sendIsSuccess Then
	  ;clear console and set cursor back to 0,0
	  Local $cursorPos = _Console_GetCursorPosition($hConsoleOutput, $__gvKernel32)
	  Local $bufferMaxSize = _Console_GetScreenBufferMaxSize($hConsoleOutput, $__gvKernel32)
	  Local $posy = $cursorPos[1] - 1
	  _Console_SetCursorPosition($hConsoleOutput, 0, 0, $__gvKernel32)
	  For $i = $posy To 0 Step -1
		 _Console_FillOutputCharacter($hConsoleOutput, " ", $bufferMaxSize[0], 0, $i, True, $__gvKernel32)
	  Next
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func TrayPrimaryUp()
    GuiSetState(@SW_Show)
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func TrayExit()
   TryExit()
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func _IsChecked($idControlID)
    Return BitAND(GUICtrlRead($idControlID), $GUI_CHECKED) = $GUI_CHECKED
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ShowGUIStart()
   $consolePID = 0
   $hConsoleWindow = 0
   $hConsoleOutput = 0

   TrayItemSetText($trayItemExit, "Exit");

   GUICtrlSetState($tabServer, $GUI_HIDE)
   GUICtrlSetState($txtSendCommand, $GUI_HIDE)
   GUICtrlSetState($btnSendCommand, $GUI_HIDE)
   GUICtrlSetState($cbAllowClientCommands, $GUI_HIDE)
   GUICtrlSetState($cbEnableMapChange, $GUI_HIDE)
   GUICtrlSetState($cbEnableDevMode, $GUI_HIDE)
   GUICtrlSetState($cbSaveConsole2, $GUI_HIDE)
   GUICtrlSetState($txtSaveConsole2, $GUI_HIDE)
   GUICtrlSetState($btnSaveConsole2, $GUI_HIDE)
   GUICtrlSetState($btnShowConsoleWindow, $GUI_HIDE)
   GUICtrlSetState($btnHideConsoleWindow, $GUI_HIDE)
   GUICtrlSetState($lblPublicIP, $GUI_HIDE)
   GUICtrlSetState($txtPublicIP, $GUI_HIDE)
   GUICtrlSetState($btnPublicIPRefresh, $GUI_HIDE)
   GUICtrlSetState($lblLocalIP, $GUI_HIDE)
   GUICtrlSetState($txtLocalIP, $GUI_HIDE)
   GUICtrlSetState($lblCredits, $GUI_HIDE)
   GUICtrlSetState($btnSaveGame0, $GUI_HIDE)
   GUICtrlSetState($btnLoadGame0, $GUI_HIDE)
   GUICtrlSetState($btnAutoLoadGame, $GUI_HIDE)
   GUICtrlSetState($lblSlot, $GUI_HIDE)
   GUICtrlSetState($cmbSaveLoadSlot, $GUI_HIDE)
   ;GUICtrlSetState($lblSaveInfo, $GUI_HIDE)
   ;GUICtrlSetState($lblSaveInfo2, $GUI_HIDE)
   ;GUICtrlSetState($lblSaveInfo3, $GUI_HIDE)
   GUICtrlSetState($lblPortInfo, $GUI_HIDE)
   GUICtrlSetState($txtPortInfo, $GUI_HIDE)
   GUICtrlSetState($cmbSendCommandType, $GUI_HIDE)
   GUICtrlSetState($cmbSendMap, $GUI_HIDE)

   GUICtrlSetState($lblExePath, $GUI_SHOW)
   GUICtrlSetState($txtExePath, $GUI_SHOW)
   GUICtrlSetState($btnExeBrowse, $GUI_SHOW)
   GUICtrlSetState($grpServer, $GUI_SHOW)
   GUICtrlSetState($lblServerName, $GUI_SHOW)
   GUICtrlSetState($txtServerName, $GUI_SHOW)
   GUICtrlSetState($lblServerMap, $GUI_SHOW)
   GUICtrlSetState($cmbServerMap, $GUI_SHOW)
   GUICtrlSetState($lblServerWebsite, $GUI_SHOW)
   GUICtrlSetState($txtServerWebsite, $GUI_SHOW)
   GUICtrlSetState($lblServerEmail, $GUI_SHOW)
   GUICtrlSetState($txtServerEmail, $GUI_SHOW)
   GUICtrlSetState($lblServerMaxPlayers, $GUI_SHOW)
   GUICtrlSetState($txtServerMaxPlayers, $GUI_SHOW)
   GUICtrlSetState($lblServerPFMOverlap, $GUI_SHOW)
   GUICtrlSetState($txtServerPFMOverlap, $GUI_SHOW)
   GUICtrlSetState($lblServerPort, $GUI_SHOW)
   GUICtrlSetState($txtServerPort, $GUI_SHOW)
   GUICtrlSetState($btnServerRun, $GUI_SHOW)
   GUICtrlSetState($btnServerPublic, $GUI_SHOW)
   GUICtrlSetState($btnServerPrivate, $GUI_SHOW)
   GUICtrlSetState($lblServerCustomArgs, $GUI_SHOW)
   GUICtrlSetState($txtServerCustomArgs, $GUI_SHOW)

   WinSetState($lstConsole, "", @SW_HIDE)
   _WinAPI_RedrawWindow($hGUI)

EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func ShowGUIServerRunning()
   TrayItemSetText($trayItemExit, "Shutdown");

   GUICtrlSetState($lblExePath, $GUI_HIDE)
   GUICtrlSetState($txtExePath, $GUI_HIDE)
   GUICtrlSetState($btnExeBrowse, $GUI_HIDE)
   GUICtrlSetState($grpServer, $GUI_HIDE)
   GUICtrlSetState($lblServerName, $GUI_HIDE)
   GUICtrlSetState($txtServerName, $GUI_HIDE)
   GUICtrlSetState($lblServerMap, $GUI_HIDE)
   GUICtrlSetState($cmbServerMap, $GUI_HIDE)
   GUICtrlSetState($lblServerWebsite, $GUI_HIDE)
   GUICtrlSetState($txtServerWebsite, $GUI_HIDE)
   GUICtrlSetState($lblServerEmail, $GUI_HIDE)
   GUICtrlSetState($txtServerEmail, $GUI_HIDE)
   GUICtrlSetState($lblServerMaxPlayers, $GUI_HIDE)
   GUICtrlSetState($txtServerMaxPlayers, $GUI_HIDE)
   GUICtrlSetState($lblServerPFMOverlap, $GUI_HIDE)
   GUICtrlSetState($txtServerPFMOverlap, $GUI_HIDE)
   GUICtrlSetState($lblServerPort, $GUI_HIDE)
   GUICtrlSetState($txtServerPort, $GUI_HIDE)
   GUICtrlSetState($btnServerRun, $GUI_HIDE)
   GUICtrlSetState($btnServerPublic, $GUI_HIDE)
   GUICtrlSetState($btnServerPrivate, $GUI_HIDE)
   GUICtrlSetState($lblServerCustomArgs, $GUI_HIDE)
   GUICtrlSetState($txtServerCustomArgs, $GUI_HIDE)

   GUICtrlSetState($tabServer, $GUI_SHOW)
   GUICtrlSetState($cmbSendCommandType, $GUI_SHOW)
   ;GUICtrlSetState($txtSendCommand, $GUI_SHOW)
   GUICtrlSetState($btnSendCommand, $GUI_SHOW)
   GUICtrlSetState($cbAllowClientCommands, $GUI_SHOW)
   GUICtrlSetState($cbEnableMapChange, $GUI_SHOW)
   GUICtrlSetState($cbEnableDevMode, $GUI_SHOW)
   GUICtrlSetState($cbSaveConsole2, $GUI_SHOW)
   GUICtrlSetState($txtSaveConsole2, $GUI_SHOW)
   GUICtrlSetState($btnSaveConsole2, $GUI_SHOW)
   GUICtrlSetState($btnShowConsoleWindow, $GUI_SHOW)
   GUICtrlSetState($btnHideConsoleWindow, $GUI_SHOW)
   GUICtrlSetState($lblPublicIP, $GUI_SHOW)
   GUICtrlSetState($txtPublicIP, $GUI_SHOW)
   GUICtrlSetState($btnPublicIPRefresh, $GUI_SHOW)
   GUICtrlSetState($lblLocalIP, $GUI_SHOW)
   GUICtrlSetState($txtLocalIP, $GUI_SHOW)
   GUICtrlSetState($lblCredits, $GUI_SHOW)
   GUICtrlSetState($btnSaveGame0, $GUI_SHOW)
   GUICtrlSetState($btnLoadGame0, $GUI_SHOW)
   GUICtrlSetState($btnAutoLoadGame, $GUI_SHOW)
   GUICtrlSetState($lblSlot, $GUI_SHOW)
   GUICtrlSetState($cmbSaveLoadSlot, $GUI_SHOW)
   ;GUICtrlSetState($lblSaveInfo, $GUI_SHOW)
   ;GUICtrlSetState($lblSaveInfo2, $GUI_SHOW)
   ;GUICtrlSetState($lblSaveInfo3, $GUI_SHOW)
   GUICtrlSetState($lblPortInfo, $GUI_SHOW)
   GUICtrlSetState($txtPortInfo, $GUI_SHOW)
   GUICtrlSetData($txtPortInfo, GUICtrlRead($txtServerPort))

   UpdateCommandType()

   $lastTabIndex = -1
   UpdateTabIndex()
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func CheckConsoleProcess()
   Local $hasProcess = ProcessExists($consolePID)
   If $lastProcessExists <> $hasProcess Then
	  $lastProcessExists = $hasProcess
	  If $hasProcess Then
		 ShowGUIServerRunning()
	  Else
		 ShowGUIStart()
	  EndIf
   EndIf
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
Func UpdateCommandType()
   GUICtrlSetState($txtSendCommand, $GUI_HIDE)
   GUICtrlSetState($cmbSendMap, $GUI_HIDE)
   Local $iIndex = _GUICtrlComboBox_GetCurSel($cmbSendCommandType)
   Switch $iIndex
	  Case 0 ;Command
		 GUICtrlSetState($txtSendCommand, $GUI_SHOW)
		 GUICtrlSetData($btnSendCommand, "Send")
	  Case 1 ;Map
		 GUICtrlSetState($cmbSendMap, $GUI_SHOW)
		 GUICtrlSetData($btnSendCommand, "Go")
   EndSwitch
EndFunc
;------------------------------------------------------------------------------------------------------------------------------------------------------
